/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Column;
import org.autoplot.dom.Row;
import org.autoplot.jythonsupport.ui.JLinkyLabel;
import org.das2.components.DatumRangeEditor;
import org.das2.components.GrannyTextEditor;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.datum.Datum;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.BorderType;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class AnnotationEditorPanel
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.gui");
    ColorEditor backgroundEditor;
    ColorEditor foregroundEditor;
    ColorEditor textColorEditor;
    EnumerationEditor anchorPositionEditor;
    BindingGroup bindings;
    DatumRangeEditor xrangeEditor;
    DatumRangeEditor yrangeEditor;
    AnchorType anchorType;
    Annotation ann;
    private EnumerationEditor anchorBorderTypeEnumerationEditor;
    private JPanel anchorBorderTypePanel;
    private JComboBox<String> anchorOffsetTF;
    private JPanel anchorPositionPanel;
    private JPanel anchorToPanel;
    private JRadioButton annotationTextButton;
    private JPanel backgroundColorPanel;
    private EnumerationEditor borderTypeEnumerationEditor;
    private JPanel borderTypePanel;
    private ButtonGroup buttonGroup1;
    private JRadioButton canvasAnchorTypeButton;
    private JPanel canvasControlPanel;
    private JComboBox<String> columnIdComboBox;
    private JCheckBox customColorsCheckBox;
    private JPanel customColorsPanel;
    private JRadioButton dataAnchorTypeButton;
    private JPanel dataControlPanel;
    private JTextField fontSizeTextField;
    private JPanel foregroundColorPanel;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel linkyLabelPanel;
    private JRadioButton plotAnchorTypeButton;
    private JPanel plotControlPanel;
    private JComboBox<String> plotIdComboBox;
    private JCheckBox pointAtCheckBox;
    private JComboBox<String> pointAtOffsetCB;
    private JPanel pointAtPanel;
    private JTextField pointAtXTF;
    private JTextField pointAtYTF;
    private JComboBox<String> rowIdComboBox;
    private JComboBox<String> scaleCB;
    private JPanel textColorPanel;
    private JTextField textField;
    private JPanel textFieldPanel;
    private JPanel textUrlPanel;
    private ButtonGroup typeButtonGroup;
    private JPanel urlPanel;
    private JTextField urlTextField;
    private JRadioButton useUrl;
    private ButtonGroup verticalButtonGroup;
    private JPanel xrangePanel;
    private JRadioButton ycanvasAnchor;
    private JRadioButton ydataAnchor;
    private JRadioButton yplotAnchor;
    private JPanel yrangePanel;
    private BindingGroup bindingGroup;

    public AnnotationEditorPanel() {
        this.initComponents();
        this.anchorType = AnchorType.CANVAS;
        this.anchorPositionEditor = new EnumerationEditor((Object)AnchorPosition.N);
        this.backgroundEditor = new ColorEditor(Color.WHITE);
        this.foregroundEditor = new ColorEditor(Color.BLACK);
        this.textColorEditor = new ColorEditor(Color.BLACK);
        this.borderTypeEnumerationEditor = new EnumerationEditor((Object)BorderType.RECTANGLE);
        this.anchorBorderTypeEnumerationEditor = new EnumerationEditor((Object)BorderType.RECTANGLE);
        this.anchorPositionPanel.add(this.anchorPositionEditor.getCustomEditor());
        this.backgroundColorPanel.add(this.backgroundEditor.getSmallEditor());
        this.foregroundColorPanel.add(this.foregroundEditor.getSmallEditor());
        this.borderTypePanel.add(this.borderTypeEnumerationEditor.getCustomEditor());
        this.anchorBorderTypePanel.add(this.anchorBorderTypeEnumerationEditor.getCustomEditor());
        this.textColorPanel.add(this.textColorEditor.getSmallEditor());
        this.xrangeEditor = new DatumRangeEditor();
        this.yrangeEditor = new DatumRangeEditor();
        this.xrangePanel.add(this.xrangeEditor.getCustomEditor());
        this.yrangePanel.add(this.yrangeEditor.getCustomEditor());
        JLinkyLabel ll = new JLinkyLabel(null, "<html>This <a href='https://github.com/autoplot/documentation/blob/master/docs/annotations.md'>web page</a> shows how the annotations are controlled.");
        this.linkyLabelPanel.add((Component)ll, "Center");
        this.validate();
    }

    public AnchorType getAnchorType() {
        return this.anchorType;
    }

    public void setAnchorType(AnchorType anchorType) {
        AnchorType oldValue = this.anchorType;
        this.anchorType = anchorType;
        if (anchorType == AnchorType.DATA) {
            this.anchorToPanel.removeAll();
            this.anchorToPanel.add((Component)this.dataControlPanel, "Center");
            this.dataAnchorTypeButton.setSelected(true);
        } else if (anchorType == AnchorType.PLOT) {
            this.anchorToPanel.removeAll();
            this.anchorToPanel.add((Component)this.plotControlPanel, "Center");
        } else if (anchorType == AnchorType.CANVAS) {
            this.anchorToPanel.removeAll();
            this.anchorToPanel.add((Component)this.canvasControlPanel, "Center");
            this.canvasAnchorTypeButton.setSelected(true);
        } else {
            return;
        }
        this.validate();
        this.repaint();
        this.firePropertyChange("anchorType", oldValue, anchorType);
    }

    private Converter getDatumToStringConverter() {
        return new Converter(){
            Units u = null;

            public Object convertForward(Object s) {
                if (this.u == null) {
                    this.u = ((Datum)s).getUnits();
                }
                return s.toString();
            }

            public Object convertReverse(Object t) {
                try {
                    return this.u.parse((String)t);
                }
                catch (ParseException ex) {
                    return this.u.createDatum(0);
                }
            }
        };
    }

    private void addBinding(BindingGroup bc, Object ann, String srcprop, Object dest, String destprop) {
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)ann, (Property)BeanProperty.create((String)srcprop), (Object)dest, (Property)BeanProperty.create((String)destprop)));
    }

    private void addBinding(BindingGroup bc, Object ann, String srcprop, Object dest, String destprop, Converter c) {
        AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)ann, (Property)BeanProperty.create((String)srcprop), (Object)dest, (Property)BeanProperty.create((String)destprop));
        b.setConverter(c);
        bc.addBinding((Binding)b);
    }

    public void doBindings(Annotation ann) {
        if (this.bindings != null) {
            throw new IllegalArgumentException("already bound");
        }
        this.ann = ann;
        this.plotIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ann.getPlotId()}));
        ArrayList<String> rows = new ArrayList<String>();
        rows.add("");
        Canvas c = null;
        if (ann.getController() != null) {
            c = ann.getController().getCanvas();
            rows.add(c.getMarginRow().getId());
            for (Row r : c.getRows()) {
                rows.add(r.getId());
            }
        }
        this.rowIdComboBox.setModel(new DefaultComboBoxModel<String>(rows.toArray(new String[rows.size()])));
        this.rowIdComboBox.setSelectedItem(ann.getRowId());
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("");
        if (ann.getController() != null) {
            c = ann.getController().getCanvas();
            columns.add(c.getMarginColumn().getId());
            for (Column c1 : c.getColumns()) {
                columns.add(c1.getId());
            }
        }
        this.columnIdComboBox.setModel(new DefaultComboBoxModel<String>(columns.toArray(new String[columns.size()])));
        this.columnIdComboBox.setSelectedItem(ann.getColumnId());
        BindingGroup bc = new BindingGroup();
        this.addBinding(bc, ann, "text", this.textField, "text_ON_ACTION_OR_FOCUS_LOST");
        this.addBinding(bc, ann, "fontSize", this.fontSizeTextField, "text_ON_ACTION_OR_FOCUS_LOST");
        this.addBinding(bc, ann, "url", this.urlTextField, "text_ON_ACTION_OR_FOCUS_LOST");
        this.addBinding(bc, ann, "scale", this.scaleCB, "selectedItem");
        this.addBinding(bc, ann, "anchorPosition", this.anchorPositionEditor, "value");
        this.addBinding(bc, ann, "anchorType", this, "anchorType");
        this.addBinding(bc, ann, "overrideColors", this.customColorsCheckBox, "selected");
        this.addBinding(bc, ann, "background", this.backgroundEditor, "value");
        this.addBinding(bc, ann, "foreground", this.foregroundEditor, "value");
        this.addBinding(bc, ann, "textColor", this.textColorEditor, "value");
        this.addBinding(bc, ann, "xrange", this.xrangeEditor, "value");
        this.addBinding(bc, ann, "yrange", this.yrangeEditor, "value");
        this.addBinding(bc, ann, "plotId", this.plotIdComboBox, "selectedItem");
        this.addBinding(bc, ann, "rowId", this.rowIdComboBox, "selectedItem");
        this.addBinding(bc, ann, "columnId", this.columnIdComboBox, "selectedItem");
        this.addBinding(bc, ann, "anchorOffset", this.anchorOffsetTF, "selectedItem");
        this.addBinding(bc, ann, "scale", this.scaleCB, "selectedItem");
        this.addBinding(bc, ann, "showArrow", this.pointAtCheckBox, "selected");
        this.addBinding(bc, ann, "pointAtX", this.pointAtXTF, "text_ON_ACTION_OR_FOCUS_LOST", this.getDatumToStringConverter());
        this.addBinding(bc, ann, "pointAtY", this.pointAtYTF, "text_ON_ACTION_OR_FOCUS_LOST", this.getDatumToStringConverter());
        this.addBinding(bc, ann, "pointAtOffset", this.pointAtOffsetCB, "selectedItem");
        this.addBinding(bc, ann, "borderType", this.borderTypeEnumerationEditor, "value");
        this.addBinding(bc, ann, "anchorBorderType", this.anchorBorderTypeEnumerationEditor, "value");
        bc.bind();
        this.bindings = bc;
        this.useUrl.setSelected(ann.getUrl().trim().length() > 0);
        this.useUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationEditorPanel.this.resetTextUrlPanel(AnnotationEditorPanel.this.useUrl.isSelected());
            }
        });
        this.resetTextUrlPanel(this.useUrl.isSelected());
    }

    private void resetTextUrlPanel(boolean useUrl) {
        this.textUrlPanel.removeAll();
        if (useUrl) {
            this.textUrlPanel.add(this.urlPanel);
        } else {
            this.textUrlPanel.add(this.textFieldPanel);
        }
        this.textUrlPanel.validate();
        this.textUrlPanel.repaint();
    }

    public void releaseBindings() {
        if (this.bindings != null) {
            this.bindings.unbind();
            this.bindings = null;
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.dataControlPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.xrangePanel = new JPanel();
        this.yrangePanel = new JPanel();
        this.plotControlPanel = new JPanel();
        this.jLabel9 = new JLabel();
        this.plotIdComboBox = new JComboBox();
        this.canvasControlPanel = new JPanel();
        this.jLabel10 = new JLabel();
        this.rowIdComboBox = new JComboBox();
        this.jLabel11 = new JLabel();
        this.columnIdComboBox = new JComboBox();
        this.urlPanel = new JPanel();
        this.urlTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.scaleCB = new JComboBox();
        this.typeButtonGroup = new ButtonGroup();
        this.borderTypeEnumerationEditor = new EnumerationEditor();
        this.textFieldPanel = new JPanel();
        this.textField = new JTextField();
        this.jButton1 = new JButton();
        this.verticalButtonGroup = new ButtonGroup();
        this.anchorBorderTypeEnumerationEditor = new EnumerationEditor();
        this.jLabel2 = new JLabel();
        this.anchorPositionPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.canvasAnchorTypeButton = new JRadioButton();
        this.jCheckBox1 = new JCheckBox();
        this.ydataAnchor = new JRadioButton();
        this.yplotAnchor = new JRadioButton();
        this.ycanvasAnchor = new JRadioButton();
        this.dataAnchorTypeButton = new JRadioButton();
        this.customColorsCheckBox = new JCheckBox();
        this.anchorToPanel = new JPanel();
        this.customColorsPanel = new JPanel();
        this.textColorPanel = new JPanel();
        this.backgroundColorPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel12 = new JLabel();
        this.foregroundColorPanel = new JPanel();
        this.jLabel13 = new JLabel();
        this.anchorOffsetTF = new JComboBox();
        this.pointAtCheckBox = new JCheckBox();
        this.annotationTextButton = new JRadioButton();
        this.useUrl = new JRadioButton();
        this.textUrlPanel = new JPanel();
        this.pointAtPanel = new JPanel();
        this.pointAtXTF = new JTextField();
        this.jLabel15 = new JLabel();
        this.jLabel14 = new JLabel();
        this.pointAtYTF = new JTextField();
        this.jLabel17 = new JLabel();
        this.pointAtOffsetCB = new JComboBox();
        this.jLabel16 = new JLabel();
        this.borderTypePanel = new JPanel();
        this.linkyLabelPanel = new JPanel();
        this.plotAnchorTypeButton = new JRadioButton();
        this.jLabel18 = new JLabel();
        this.anchorBorderTypePanel = new JPanel();
        this.jLabel19 = new JLabel();
        this.fontSizeTextField = new JTextField();
        this.dataControlPanel.setAlignmentX(0.0f);
        this.dataControlPanel.setAlignmentY(0.0f);
        this.jLabel6.setText("x:");
        this.jLabel7.setText("Two ranges define a box in data space.");
        this.jLabel8.setText("y:");
        this.xrangePanel.setLayout(new BorderLayout());
        this.yrangePanel.setLayout(new BorderLayout());
        GroupLayout dataControlPanelLayout = new GroupLayout(this.dataControlPanel);
        this.dataControlPanel.setLayout(dataControlPanelLayout);
        dataControlPanelLayout.setHorizontalGroup(dataControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataControlPanelLayout.createSequentialGroup().addComponent(this.jLabel6).addGap(3, 3, 3).addComponent(this.xrangePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yrangePanel, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel7));
        dataControlPanelLayout.setVerticalGroup(dataControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataControlPanelLayout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dataControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.yrangePanel, -2, 27, -2).addComponent(this.xrangePanel, -2, 27, -2).addComponent(this.jLabel8, -2, 21, -2).addComponent(this.jLabel6, -2, 27, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        dataControlPanelLayout.linkSize(1, this.jLabel6, this.jLabel8, this.xrangePanel, this.yrangePanel);
        this.plotControlPanel.setAlignmentX(0.0f);
        this.plotControlPanel.setAlignmentY(0.0f);
        this.jLabel9.setText("Plot containing annotation:");
        this.plotIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.plotIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationEditorPanel.this.plotIdComboBoxActionPerformed(evt);
            }
        });
        GroupLayout plotControlPanelLayout = new GroupLayout(this.plotControlPanel);
        this.plotControlPanel.setLayout(plotControlPanelLayout);
        plotControlPanelLayout.setHorizontalGroup(plotControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotControlPanelLayout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotIdComboBox, 0, 140, Short.MAX_VALUE)));
        plotControlPanelLayout.setVerticalGroup(plotControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotControlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.plotIdComboBox, -2, -1, -2)));
        this.canvasControlPanel.setAlignmentX(0.0f);
        this.canvasControlPanel.setAlignmentY(0.0f);
        this.jLabel10.setText("Row:");
        this.rowIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel11.setText("Column:");
        this.columnIdComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout canvasControlPanelLayout = new GroupLayout(this.canvasControlPanel);
        this.canvasControlPanel.setLayout(canvasControlPanelLayout);
        canvasControlPanelLayout.setHorizontalGroup(canvasControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(canvasControlPanelLayout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rowIdComboBox, 0, 84, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnIdComboBox, 0, 84, Short.MAX_VALUE).addGap(18, 18, 18)));
        canvasControlPanelLayout.setVerticalGroup(canvasControlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(canvasControlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.rowIdComboBox, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.columnIdComboBox, -2, -1, -2)));
        this.urlTextField.setText("jTextField1");
        this.jLabel1.setText("Scale:");
        this.scaleCB.setEditable(true);
        this.scaleCB.setModel(new DefaultComboBoxModel<String>(new String[]{"1.10", "1.00", ".80", ".60", ".50", ".20", ".10", " "}));
        this.scaleCB.setToolTipText("Scale the image by this amount");
        GroupLayout urlPanelLayout = new GroupLayout(this.urlPanel);
        this.urlPanel.setLayout(urlPanelLayout);
        urlPanelLayout.setHorizontalGroup(urlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(urlPanelLayout.createSequentialGroup().addComponent(this.urlTextField, -1, 286, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleCB, -2, 89, -2)));
        urlPanelLayout.setVerticalGroup(urlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(urlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlTextField, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.scaleCB, -2, -1, -2)));
        this.textField.setText("jTextField1");
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout textFieldPanelLayout = new GroupLayout(this.textFieldPanel);
        this.textFieldPanel.setLayout(textFieldPanelLayout);
        textFieldPanelLayout.setHorizontalGroup(textFieldPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(textFieldPanelLayout.createSequentialGroup().addComponent(this.textField, -1, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 25, -2)));
        textFieldPanelLayout.setVerticalGroup(textFieldPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(textFieldPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.textField, -2, -1, -2)));
        this.jLabel2.setText("Position:");
        this.anchorPositionPanel.setLayout(new BorderLayout());
        this.jLabel3.setText("Anchor To:");
        this.buttonGroup1.add(this.canvasAnchorTypeButton);
        this.canvasAnchorTypeButton.setSelected(true);
        this.canvasAnchorTypeButton.setText("Canvas");
        this.canvasAnchorTypeButton.setToolTipText("Annotation is anchored to a row and column on the canvas, or to the canvas itsself.");
        this.canvasAnchorTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationEditorPanel.this.canvasAnchorTypeButtonActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("vertical anchor:");
        this.jCheckBox1.setToolTipText("Anchor vertical to this instead");
        this.verticalButtonGroup.add(this.ydataAnchor);
        this.ydataAnchor.setText("Data");
        this.verticalButtonGroup.add(this.yplotAnchor);
        this.yplotAnchor.setText("Plot");
        this.verticalButtonGroup.add(this.ycanvasAnchor);
        this.ycanvasAnchor.setText("Canvas");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.canvasAnchorTypeButton).addGap(18, 18, 18).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ydataAnchor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yplotAnchor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ycanvasAnchor).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.canvasAnchorTypeButton).addComponent(this.jCheckBox1).addComponent(this.ydataAnchor).addComponent(this.yplotAnchor).addComponent(this.ycanvasAnchor))));
        this.buttonGroup1.add(this.dataAnchorTypeButton);
        this.dataAnchorTypeButton.setText("Data");
        this.dataAnchorTypeButton.setToolTipText("Annotation is anchored to the data itself, using xrange and yrange properties");
        this.dataAnchorTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationEditorPanel.this.dataAnchorTypeButtonActionPerformed(evt);
            }
        });
        this.customColorsCheckBox.setText("Custom Colors");
        this.customColorsCheckBox.setToolTipText("(property is overrideColors)");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.customColorsPanel, (Property)ELProperty.create((String)"${visible}"), (Object)this.customColorsCheckBox, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.anchorToPanel.setAlignmentX(0.0f);
        this.anchorToPanel.setLayout(new BorderLayout());
        this.textColorPanel.setLayout(new BorderLayout());
        this.backgroundColorPanel.setLayout(new BorderLayout());
        this.jLabel5.setText("Background:");
        this.jLabel4.setText("Text Color:");
        this.jLabel12.setText("Foreground:");
        this.foregroundColorPanel.setLayout(new BorderLayout());
        GroupLayout customColorsPanelLayout = new GroupLayout(this.customColorsPanel);
        this.customColorsPanel.setLayout(customColorsPanelLayout);
        customColorsPanelLayout.setHorizontalGroup(customColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customColorsPanelLayout.createSequentialGroup().addGroup(customColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundColorPanel, -1, 191, Short.MAX_VALUE).addComponent(this.textColorPanel, -1, -1, Short.MAX_VALUE))).addGroup(customColorsPanelLayout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.foregroundColorPanel, -1, -1, Short.MAX_VALUE)));
        customColorsPanelLayout.setVerticalGroup(customColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customColorsPanelLayout.createSequentialGroup().addGroup(customColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.textColorPanel, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.foregroundColorPanel, -2, 23, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.backgroundColorPanel, -2, 21, -2).addComponent(this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        customColorsPanelLayout.linkSize(1, this.backgroundColorPanel, this.foregroundColorPanel, this.textColorPanel);
        this.jLabel13.setText("Anchor Offset:");
        this.jLabel13.setToolTipText("<html>The offset from the anchor position, in ems or pixels. <br>The offset direction depends on the anchor position. <br>For example, if the anchor is \"N\" then offsets move towards <br>the south and east.");
        this.anchorOffsetTF.setEditable(true);
        this.anchorOffsetTF.setModel(new DefaultComboBoxModel<String>(new String[]{"0em,0em", "1em,1em", "10px,10px", " "}));
        this.pointAtCheckBox.setText("Point At:");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.pointAtPanel, (Property)ELProperty.create((String)"${visible}"), (Object)this.pointAtCheckBox, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.typeButtonGroup.add(this.annotationTextButton);
        this.annotationTextButton.setSelected(true);
        this.annotationTextButton.setText("Annotation Text:");
        this.annotationTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationEditorPanel.this.annotationTextButtonActionPerformed(evt);
            }
        });
        this.typeButtonGroup.add(this.useUrl);
        this.useUrl.setText("Image URL:");
        this.useUrl.setToolTipText("This is no longer supported, see image in granny strings");
        this.useUrl.setEnabled(false);
        this.useUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationEditorPanel.this.useUrlActionPerformed(evt);
            }
        });
        this.textUrlPanel.setLayout(new BorderLayout());
        this.pointAtXTF.setText("0.0");
        this.jLabel15.setText("y:");
        this.jLabel14.setText("x:");
        this.pointAtYTF.setText("0.0");
        this.jLabel17.setText("point at offset:");
        this.jLabel17.setToolTipText("Amount to back off from the target");
        this.pointAtOffsetCB.setEditable(true);
        this.pointAtOffsetCB.setModel(new DefaultComboBoxModel<String>(new String[]{"0em", "0.5em", "1em", ""}));
        GroupLayout pointAtPanelLayout = new GroupLayout(this.pointAtPanel);
        this.pointAtPanel.setLayout(pointAtPanelLayout);
        pointAtPanelLayout.setHorizontalGroup(pointAtPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pointAtPanelLayout.createSequentialGroup().addGroup(pointAtPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pointAtPanelLayout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pointAtXTF, -2, 133, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pointAtYTF, -2, 123, -2)).addGroup(pointAtPanelLayout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pointAtOffsetCB, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        pointAtPanelLayout.setVerticalGroup(pointAtPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pointAtPanelLayout.createSequentialGroup().addGroup(pointAtPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.pointAtXTF, -2, -1, -2).addComponent(this.jLabel15).addComponent(this.pointAtYTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pointAtPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.pointAtOffsetCB, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel16.setText("Border Type:");
        this.borderTypePanel.setLayout(new BorderLayout());
        this.linkyLabelPanel.setLayout(new BorderLayout());
        this.buttonGroup1.add(this.plotAnchorTypeButton);
        this.plotAnchorTypeButton.setText("Plot");
        this.plotAnchorTypeButton.setToolTipText("Annotation is anchored to the plot, can can refer to context and the data.  ");
        this.plotAnchorTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnnotationEditorPanel.this.plotAnchorTypeButtonActionPerformed(evt);
            }
        });
        this.jLabel18.setText("Anchor Border Type:");
        this.anchorBorderTypePanel.setLayout(new BorderLayout());
        this.jLabel19.setText("FontSize:");
        this.fontSizeTextField.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textUrlPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.anchorToPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataAnchorTypeButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.plotAnchorTypeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addComponent(this.linkyLabelPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anchorPositionPanel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.customColorsPanel, -2, -1, -2)).addComponent(this.customColorsCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anchorOffsetTF, -2, 203, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.borderTypePanel, -2, 215, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.pointAtPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anchorBorderTypePanel, -2, 215, -2)).addComponent(this.pointAtCheckBox)).addGap(0, 6, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.annotationTextButton).addGap(18, 18, 18).addComponent(this.useUrl)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontSizeTextField, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.annotationTextButton).addComponent(this.useUrl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textUrlPanel, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent(this.fontSizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.dataAnchorTypeButton).addComponent(this.plotAnchorTypeButton)).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anchorToPanel, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.anchorPositionPanel, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel18, -1, -1, Short.MAX_VALUE).addComponent(this.borderTypePanel, -2, 16, -2)).addComponent(this.anchorBorderTypePanel, -2, 20, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.anchorOffsetTF, -2, -1, -2).addComponent(this.pointAtCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.customColorsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customColorsPanel, -2, -1, -2)).addComponent(this.pointAtPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addComponent(this.linkyLabelPanel, -2, 20, -2).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void dataAnchorTypeButtonActionPerformed(ActionEvent evt) {
        if (this.dataAnchorTypeButton.isSelected()) {
            this.setAnchorType(AnchorType.DATA);
        }
    }

    private void canvasAnchorTypeButtonActionPerformed(ActionEvent evt) {
        if (this.canvasAnchorTypeButton.isSelected()) {
            this.setAnchorType(AnchorType.CANVAS);
        }
    }

    private void annotationTextButtonActionPerformed(ActionEvent evt) {
        this.resetTextUrlPanel(this.useUrl.isSelected());
    }

    private void useUrlActionPerformed(ActionEvent evt) {
        this.resetTextUrlPanel(this.useUrl.isSelected());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        GrannyTextEditor textedit = AutoplotUI.newGrannyTextEditorWithMacros();
        textedit.setValue(this.textField.getText());
        if (0 == JOptionPane.showConfirmDialog(this, textedit, "Edit Text", 2)) {
            this.textField.setText(textedit.getValue());
            this.ann.setText(textedit.getValue());
        }
    }

    private void plotAnchorTypeButtonActionPerformed(ActionEvent evt) {
        if (this.plotAnchorTypeButton.isSelected()) {
            this.setAnchorType(AnchorType.PLOT);
        }
    }

    private void plotIdComboBoxActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        AnnotationEditorPanel p = new AnnotationEditorPanel();
        Annotation a = new Annotation();
        p.doBindings(a);
        AutoplotUtil.showMessageDialog(null, p, "tester", 0);
    }
}

